
//._________________________________________________________.//
//|                                                         |//
//|            __?_____             ?                       |//
//|           /        \          ?      _______           /|//
//|  ___     /          \          ?    /       \         / |//
//| /   \___/            \          .--|O     O  \--.    /  |//
//|/                      \        /   |   V     /   \  /   |//
//|                        \      /     \_______/     \/    |//
//|                         \    /      /    \  \     /\    |//
//|__________________________\__/______/______\__\___/__\___|//

import oscP5.*;
import netP5.*;

OscP5 oscP5;
NetAddress myRemoteLocation;

import fullscreen.*;  
FullScreen fs; 

import sojamo.drop.*;
import processing.video.*;

boolean recordOn=false;//enregistrer ?
MovieMaker mm;
boolean exportPNG=false;//enregistrer ?

PFont[] font=new PFont[4];

float curPos;

int sizx=600;
int sizy=500;

int phase=0;

int nbMonstres=40;//nombre de monstres dans le bestiaire

int nbLangues=2;
int langue=1;
int languePrev=langue;

String lettres = "abcdefghijklmnopqrstuvwxyz";
String consonnes = "bcdfghjklmnpqrstvwxz";
String voyelles = "aeiouy";

void setup() {
  colorMode(HSB);
  size(sizx,sizy);
  smooth();
  frameRate(15);

  fs = new FullScreen(this); 

  if (recordOn) mm = new MovieMaker(this, width, height, "scene.mov", 30, MovieMaker.H263, MovieMaker.HIGH);

  oscP5 = new OscP5(this,12000);
  myRemoteLocation = new NetAddress("127.0.0.1",12001);
  oscP5.plug(this,"tic","/tic");
  oscP5.plug(this,"midiS","/midiS");  
  oscP5.plug(this,"sonPP5","/sonPP5");    

  chargePays();
  sendGeneral();

  font[0] = loadFont("BorisBlackBloxx-20.vlw");
  font[1] = loadFont("BorisBlackBloxx-30.vlw");  
  font[2] = loadFont("BorisBlackBloxx-40.vlw");  
  font[3] = loadFont("BorisBlackBloxx-50.vlw");  

  fondPopUp=new PImage(width,height);

  addMouseWheelListener(new java.awt.event.MouseWheelListener() {
    public void mouseWheelMoved(java.awt.event.MouseWheelEvent evt) {
      if (phase==3) {
        tempo+=evt.getWheelRotation();
        tempo=constrain(tempo,1,10);
      }
    }
  }
  );

  chargeBestiaire();
  chargeScene();
  changeLangue();  

  loadTheFile();

  setupIntro();
}

void draw() {
  if (phase==0) {
    phaseA();
  }
  if (phase==1) {
    phaseB();
  }
  if (phase==2) {
    phaseC();
  }
  if (phase==3) {
    phaseD();
  }
  if (phase==4) {
    phaseE();
  }
  if (phase==5) {
    phaseF();
  }
  if (phase==6) {
    phaseG();
  }
  if (phase==7) {
    phaseH();
  }
  recordEv();
  if (languePrev!=langue) {
    changeLangue();  
    languePrev=langue;
  }
}

String message="";
int afficheMes=0;

public void recordEv() {
  if (afficheMes>0) {
    afficheMes--;
    noStroke();
    fill(0,192,192);
    textFont(font[2], (width+height)/30);
    textAlign(LEFT,CENTER);
    text(message, width/10, height/10); 
  }
}

public void stop() {
  saveTheFile();
  if (recordOn) {  
    mm.finish();
  }
}
